/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.server.core.channel;

import java.rmi.Remote;
import java.rmi.RemoteException;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventResult;

/**
 * Remote interface for admin channel
 */
public interface RemoteAdminChannel extends Remote {

    // WARNING - Please make sure that the first parameter to all methods in
    // this interface is byte[] key. This is used in validating access. Not
    // having byte[] key will compromise security. Please see the implementation
    // class (AdminChannelServer) for details on how byte[] key is used.

    /**
     * Send a event notification.
     * @param event the event
     * @param key shared secret
     */
    public AdminEventResult sendNotification(byte[] key, AdminEvent event)
            throws RemoteException;

    /**
     * Ping server.
     */
    public boolean pingServer(byte[] key) throws RemoteException;

    /**
     * Get server status code. This method will return one of the following
     * constants from class <code>com.sun.enterprise.admin.common.Status</code>
     * -- <code>kInstanceStartingCode, kInstanceRunningCode or
     * kInstanceStoppingCode</code> representing starting, running and stopping
     * condition for the instance. 
     * @param key shared secret
     * @returns server status code denoting whether server is starting,
     *     running or stopping.
     */
    public int getServerStatusCode(byte[] key) throws RemoteException;

    /**
     * Is restart needed to use persistent server configuration. After a
     * notification, the server may be in inconsistenet state with respect
     * to persistent configuration because all changes to configuration can
     * not be handled dynamically - A restart is needed in such cases to
     * synchronize server with persistent configuration.
     * @param key shared secret
     * @return true if restart is required, false otherwise.
     */
    public boolean isRestartNeeded(byte[] key) throws RemoteException;

    /**
     * Set restart needed status on server instance.
     * @param key shared secret
     * @param needRestart true if the instance should be restarted to use
     *     changes in persistent configuration.
     */
    public void setRestartNeeded(byte[] key, boolean needRestart)
            throws RemoteException;

    /**
     * Obtain the port number that caused the port conflict. This should
     * be invoked only if Status is kInstaceFailedCode
     * @param key shared secret
     * @return port number.
     */
    public int getConflictedPort(byte[] key) throws RemoteException;

    /**
     *  Trigger server exit now. This is applicable only for 
     *  AS Socket Service based startup now.
     *  @param key shared secret
     */
    public void triggerServerExit(byte[] key) throws RemoteException ;

}
