/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.server.core.jmx.auth;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.logging.Level;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;

import com.sun.enterprise.admin.common.constant.AdminConstants;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.i18n.StringManager;

public class ASLoginDriverImpl implements LoginDriver {

    private static final String ASADMIN_GROUP = "asadmin";

    private static Logger _logger =
            Logger.getLogger(AdminConstants.kLoggerName);

    private static StringManager _strings =
            StringManager.getManager(ASLoginDriverImpl.class);

    public ASLoginDriverImpl() {
    }

    public Subject login(String user, String password, String realm) {
        LoginContextDriver.login(user, password, realm);
        // Login succeeded, try authorization
        authorize(user, password, realm);
        /* **
        ** TODO: The subject needs to be initialized properly 
        JMXPrincipal principal = new JMXPrincipal(user);
        HashSet principalSet = new HashSet();
        principalSet.add(principal);
        Subject subj = new Subject(true, principalSet, new HashSet(),
                new HashSet());
        return subj;
        ** */
        return null;
    }

    private void authorize(String user, String password, String realmName) {
        boolean isAuthorized = false;
        try {
            boolean isValid = Realm.isValidRealm(realmName);
            if (!isValid) {
                realmName = Realm.getDefaultRealm();
            }
            Realm realm = Realm.getInstance(realmName);
            Enumeration groups = realm.getGroupNames(user);
            while (groups != null && groups.hasMoreElements()) {
                String groupName = (String)groups.nextElement();
                if (ASADMIN_GROUP.equals(groupName)) {
                    isAuthorized = true;
                    break;
                }
            }
        } catch (Exception ee) {
            _logger.log(Level.WARNING, "core.auth_failed", realmName);
            _logger.log(Level.INFO, "core.auth_fail_exception", ee);
            SecurityException se = new SecurityException(
                    _strings.getString("admin.auth.failed"));
            se.initCause(ee);
            throw se;
        }
        if (!isAuthorized) {
            throw new SecurityException(
                    _strings.getString("admin.auth.failed.nogroup"));
        }
        return;
    }

}
