/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

/**
    Represents a manageable J2EE servlet. Servlet will expose some manageable
    attributes defined by its descriptor and they will be made available.
    For every Servlet that is loaded by a running Server Instance, there will
    be a correponding MBean registered in the MBeanServer. Note that the life
    cycle of Servlet is not manageable by this interface, because it is
    not exposed by its descriptor.
    <p>
    The Servlet can be running as a part of deployed application or an
    independently deployed module. In case the servlet is loaded from an
    independently deployed module, the application name (in the ObjectName)
    is treated as default application name or null.
    <p>
    Object Name of this MBean is:
        ias:type=J2EEServlet, AppName=<appName>, ModuleName=<modName>,
        ServletName=<servletName>
*/
public class ManagedJ2EEServlet extends AdminBase
{
    /** Every resource MBean should override this method to execute specific
     * operations on the MBean. This method is enhanced in 8.0. It was a no-op
     * in 7.0. In 8.0, it is modified to invoke the actual method through
     * reflection.
     * @since 8.0
     * @see javax.management.MBeanServer#invoke
     * @see #getImplementingClass
     */
    protected Class getImplementingClass() {
        return ( this.getClass() );
    }
    
    /** Reflection requires the implementing object.  */
    protected Object getImplementingMBean() {
        return ( this );
    }
}
