/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

//JMX imports
import javax.management.*;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;

//Admin imports
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;

/**
    This Config MBean represents a JDBC Connection Pool resource.
    It extends ConfigMBeanBase class which provides get/set attribute(s) and getMBeanInfo services according to text descriptions.
    ObjectName of this MBean is:
        ias: type=jdbcpool, instance-name=<instance-name>, name=<resource-name>
*/
public class ManagedJDBCConnectionPool extends ConfigMBeanBase implements ConfigAttributeName.JDBCConnectionPool
{
    /** 
     * MAPLIST array defines mapping between "external" name and its location in XML relatively base node
     */
    private static final String[][] MAPLIST  =  {
       {kId                             , ATTRIBUTE + ServerTags.NAME },
       {kDatasourceClassName            , ATTRIBUTE + ServerTags.DATASOURCE_CLASSNAME},
       {kResType                        , ATTRIBUTE + ServerTags.RES_TYPE },
       {kMinConnectionsInPool           , ATTRIBUTE + ServerTags.STEADY_POOL_SIZE },
       {kMaxConnectionsInPool           , ATTRIBUTE + ServerTags.MAX_POOL_SIZE },
       {kMaxConnectionsWaitTime         , ATTRIBUTE + ServerTags.MAX_WAIT_TIME_IN_MILLIS },
       {kConnectionsIncrement           , ATTRIBUTE + ServerTags.POOL_RESIZE_QUANTITY },
       {kConnectionIdleTimeout          , ATTRIBUTE + ServerTags.IDLE_TIMEOUT_IN_SECONDS },
       {kTransactionIsolationLevel      , ATTRIBUTE + ServerTags.TRANSACTION_ISOLATION_LEVEL },
       {kIsIsolationLevelGuaranteed     , ATTRIBUTE + ServerTags.IS_ISOLATION_LEVEL_GUARANTEED },
       {kIsConnectionValidationRequired , ATTRIBUTE + ServerTags.IS_CONNECTION_VALIDATION_REQUIRED },
       {kConnectionValidation           , ATTRIBUTE + ServerTags.CONNECTION_VALIDATION_METHOD },
       {kValidationTableName            , ATTRIBUTE + ServerTags.VALIDATION_TABLE_NAME },
       {kFailAllConnections             , ATTRIBUTE + ServerTags.FAIL_ALL_CONNECTIONS },
       {kDescription                    , ATTRIBUTE + PSEUDO_ATTR_DESCRIPTION},
      }; 

     /** 
     * ATTRIBUTES array specifies attributes descriptions in format defined for MBeanEasyConfig
     */
    private static final String[]   ATTRIBUTES  = {
        kId                             + " ,String,      R"  ,
        kDatasourceClassName            + ", String,      RW"  ,    
        kResType                        + " ,String,      RW"  ,
        kMinConnectionsInPool           + " ,int,         RW"  ,
        kMaxConnectionsInPool           + " ,int,         RW"  ,
        kMaxConnectionsWaitTime         + " ,int,         RW"  ,
        kConnectionsIncrement           + " ,int,         RW"  ,
        kConnectionIdleTimeout          + " ,int,         RW"  ,
        kTransactionIsolationLevel      + " ,String,      RW"  ,
        kIsIsolationLevelGuaranteed     + " ,boolean,     RW"  ,
        kIsConnectionValidationRequired + " ,boolean,     RW"  ,
        kConnectionValidation           + " ,String,      RW"  ,
        kValidationTableName            + " ,String,      RW"  ,
        kFailAllConnections             + " ,boolean,     RW"  ,
        kDescription                    + ", String,      RW"  ,
       };

    /** 
     * OPERATIONS array specifies operations descriptions in format defined for MBeanEasyConfig
     */
    private static final String[]   OPERATIONS  = null;

    /**
        Default constructor sets MBean description tables
    */
    public ManagedJDBCConnectionPool() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    /**
        Constructs Config MBean for JDBC Connection Pool Resource.
        @param instanceName The server instance name.
        @param poolId     Id for given pool
    */
    public ManagedJDBCConnectionPool(String instanceName, String poolId) throws MBeanConfigException
    {
        this(); //set description tables
        initialize(ObjectNames.kJdbcConnectionPoolType, new String[]{instanceName, poolId});
    }

}
