/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

//JMX imports
import javax.management.*;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.Profiler;


//Admin imports
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;

/**
    This Config MBean represents a Profiler element.
    It extends ConfigMBeanBase class which provides get/set attribute(s) and getMBeanInfo services according to text descriptions.
    ObjectName of this MBean is:
        ias: type=auth-db, instance-name=<instance-name>, class=<virtualServerClassId>, server=<virtualServerId> name=<AuthDb-id>
*/
public class ManagedProfiler extends ConfigMBeanBase implements ConfigAttributeName.Profiler
{
    /**
     * MAPLIST array defines mapping between "external" name and its location in XML relatively base node
     */
    private static final String[][] MAPLIST  =
    {
        {kName              , ATTRIBUTE + ServerTags.NAME},
        {kClasspath         , ATTRIBUTE + ServerTags.CLASSPATH},
        {kNativeLibraryPath , ATTRIBUTE + ServerTags.NATIVE_LIBRARY_PATH},
        {kEnabled           , ATTRIBUTE + ServerTags.ENABLED},
    };
    /** 
     * ATTRIBUTES array specifies attributes descriptions in format defined for MBeanEasyConfig
     */
    private static final String[]   ATTRIBUTES  =
    {
        kName               + ", String,   R" ,
        kClasspath          + ", String,   RW" ,
        kNativeLibraryPath  + ", String,   RW" ,
        kEnabled            + ", boolean,  RW" ,
    };
    /** 
     * OPERATIONS array specifies operations descriptions in format defined for MBeanEasyConfig
     */
    private static final String[]   OPERATIONS  =
    {
        "getJvmOptions(), INFO",
        "setJvmOptions(String[] options), ACTION",
    };
    
    /**
        Default constructor sets MBean description tables
    */
    public ManagedProfiler() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    /**
        Constructs Config MBean for Profiler.
        @param instanceName The server instance name.
    */
    public ManagedProfiler(String instanceName) throws MBeanConfigException
    {
        this(); //set description tables
        initialize(ObjectNames.kProfiler, new String[]{instanceName});
    }
    /**
    This operation returns list of JvmOptions  connected to this class.
     */
    public String[] getJvmOptions() throws ConfigException
    {
        Profiler  profiler  = (Profiler)getBaseConfigBean();
        return profiler.getJvmOptions();
    }

    /**
    This operation returns list of JvmOptions  connected to this class.
     */
    public void setJvmOptions(String[] options) throws ConfigException
    {
        Profiler  profiler  = (Profiler)getBaseConfigBean();
        profiler.setJvmOptions(options);
        getConfigContext().flush();
    }
}
