/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.test;

import javax.management.*;
import com.sun.enterprise.admin.server.core.mbean.meta.MBeanInfoBuilder;
import com.sun.enterprise.admin.util.*;

public class MBeanInfoBuilderTester
{

	/** 
		 Creates new MBeanInfoTester
	*/
    
	public MBeanInfoBuilderTester()
	{
    }

    /**
		@param args the command line arguments
    */
    
	public static void main (String args[])
	{
		new MBeanInfoBuilderTester().test();
    }

	public void test()
	{
		String[] mbeanNames = new String[]{
			"com.sun.enterprise.admin.server.core.mbean.test.ManagedTest",
			"com.sun.enterprise.admin.server.core.mbean.config.ServerController",
			"com.sun.enterprise.admin.server.core.mbean.config.ManagedServerInstance"
		};
		try
		{
			for (int i1 = 0 ; i1 < mbeanNames.length ; i1 ++)
			{
				Class cl = Class.forName(mbeanNames[i1]);
				MBeanInfoBuilder builder = new MBeanInfoBuilder(cl);
				MBeanInfo mi = builder.getMBeanInfo ();
				MBeanAttributeInfo[]  attrs = mi.getAttributes();
				for (int i = 0 ; i < attrs.length ; i++)
				{
					Logger.log("Attr: " + attrs[i].getName ());
				}
				MBeanOperationInfo[] operations = mi.getOperations();
				for (int i = 0 ; i < operations.length ; i++)
				{
					MBeanOperationInfo oper = operations[i];
					Logger.log("Oper: name = " + oper.getName());
					Logger.log("Signature: ");
					MBeanParameterInfo[] params = oper.getSignature ();
					for (int j = 0 ; j < params.length ; j++)
					{
						Logger.log("ParamType = " + params[j].getType());
					}

				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
}