/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: ConfigTarget.java,v 1.3 2005/12/25 04:14:38 tcfujii Exp $
 */

package com.sun.enterprise.admin.target;

//jdk imports
import java.io.Serializable;
import java.util.Set;

//config imports
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;

public class ConfigTarget extends Target
{
    private static final StringManager strMgr = 
        StringManager.getManager(ConfigTarget.class);

    protected ConfigTarget(String name, ConfigContext cc)
    {
        super(name, cc);
    }

    public TargetType getType()
    {
        return TargetType.CONFIG;
    }

    public String getTargetObjectName(String[] tokens)
    {
        checkTokens(tokens, 1);
        return (tokens[0] + ":type=config,category=config,name=" + getName());
    }

    public ConfigTarget getConfigTarget() throws Exception
    {
        return this;
    }

    public String getConfigRef() throws ConfigException
    {
        return getName();
    }

    /**
     * Return all the servers in referencing this config
     */    
    public Server[] getServers() throws ConfigException
    {
        return ServerHelper.getServersReferencingConfig(getConfigContext(), getName());
    }

    /**
     * Return all the clusters referencing this config
     */
    public Cluster[] getClusters() throws ConfigException
    {
        return ClusterHelper.getClustersReferencingConfig(getConfigContext(), getName());
    }
    
    
    /**
     * Return the configuration
     */    
    public Config[] getConfigs() throws ConfigException
    {
        Config[] configs = new Config[1];
        configs[0] = ConfigAPIHelper.getConfigByName(getConfigContext(), getName());
        return configs;
    }

    public NodeAgent[] getNodeAgents() throws ConfigException
    {
        throw new ConfigException(strMgr.getString("target.not_supported",
            "getNodeAgents", getType().getName()));
    }  
    
    public ApplicationRef[] getApplicationRefs() throws ConfigException
    {
        throw new ConfigException(strMgr.getString("target.not_supported",
            "getApplicationRefs", getType().getName()));
    }
    
    public ResourceRef[] getResourceRefs() throws ConfigException
    {
        throw new ConfigException(strMgr.getString("target.not_supported",
            "getResourceRefs", getType().getName()));
    }    
}
