/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.util;

// JDK includes
import java.io.Serializable;


/**
    Represents the result of validation by an IValidator.
 */
public class ValidatorResult implements Serializable
{
    private final boolean	mValid;
    private final String	mMsg;	// may be null

    // don't new up a new ValidatorResult every time an object is valid;
    // instead use this prebuilt one over and over.
    public static final ValidatorResult	kValid	= new ValidatorResult();

    /**
        Constructor intended for non-public use by Assert.
     */
    public ValidatorResult( boolean valid, String msg )
    {
        mValid	= valid;

        // keep message only if invalid (convenience for caller)
        mMsg	= valid ? null : msg;
    }

    /**
        Constructor indicates validation succeeded.
     */
    protected ValidatorResult( )
    {
        mValid	= true;
        mMsg	= null;
    }

    /**
        Return True if valid, false otherwise.

        @returns  true if valid, false otherwise
     */
    public boolean isValid()
    {
        return( mValid );
    }

    /**
        Return a String describing the validation failure.  A null will
        be returned if there was no failure.

        @returns  validation failure String (may be null if no failure)
     */
    public String getString()
    {
        return( mMsg );
    }

    /**
        Represent as a String
     */
    public String toString()
    {
        String	result	= null;

        if ( mValid )
        {
            result	= "valid";
        }
        else
        {
            result	= "INVALID = " + getString();
        }

        return( result );
    }
}