/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient;

import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;

/**
 * Represents an app client specified by a .class file on the command line.
 * @author tjquinn
 */
public class ClassFileAppClientInfo extends AppClientInfo {
    
    /** the class file name specified on the command line */
    private String classFileFromCommandLine;
    
    /**
     *Creates a new instance of the class file app client info.
     *@param isJWS whether Java Web Start was used to launch the app client
     *@param logger the Logger available for writing log messages
     *@param archive the archive containing the app client (and perhaps other files as well)
     *@param archivist the archivist appropriate to the type of archive being processed
     *@param mainClassFromCommandLine the main class command-line argument value
     *@param classFileFromCommandLine the class file name from the command line arguments
     */
    protected ClassFileAppClientInfo(
            boolean isJWS, Logger logger, File archive, 
            Archivist archivist, String mainClassFromCommandLine, 
            String classFileFromCommandLine) {
        super(isJWS, logger, archive, archivist, mainClassFromCommandLine);
        this.classFileFromCommandLine = classFileFromCommandLine;
    }

    protected String getMainClassNameToRun(ApplicationClientDescriptor acDescr) {
        return classFileFromCommandLine;
    }

    protected void messageDescriptor(RootDeploymentDescriptor d, 
        Archivist archivist, AbstractArchive archive) 
            throws IOException, AnnotationProcessorException {
        ApplicationClientDescriptor appClient = (ApplicationClientDescriptor)d;
        appClient.setMainClassName(classFileFromCommandLine);
        appClient.getModuleDescriptor().setStandalone(true);
        archivist.processAnnotations(appClient, archive);
    }
    
    protected AbstractArchive expand(File file) 
        throws IOException, Exception {
        FileArchive appArchive = new FileArchive();
        appArchive.open(file.getAbsolutePath());
        return appArchive;
    }

    protected boolean deleteAppClientDir() {
        return false;
    }
}
