/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient;

import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.util.AnnotationDetector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

/**
 * Represents an app client that is in a stand-alone archive, not inside an
 * enterprise app archive and not a .class file.
 * @author tjquinn
 */
public class StandAloneAppClientInfo extends AppClientInfo {
    
    public StandAloneAppClientInfo(
            boolean isJWS, Logger logger, File archive, 
            Archivist archivist, String mainClassFromCommandLine) 
        throws IOException, ClassNotFoundException, 
               URISyntaxException, SAXParseException {
        super(isJWS, logger, archive, archivist, mainClassFromCommandLine);
    }

    protected AbstractArchive expand(File file) 
        throws IOException, Exception {
        InputJarArchive  appArchive = new InputJarArchive ();
        appArchive.open(file.getAbsolutePath());
        return appArchive;
    }

    protected boolean deleteAppClientDir() {
        return false;
    }

    protected void messageDescriptor(RootDeploymentDescriptor d, 
        Archivist archivist, AbstractArchive archive) 
            throws IOException, AnnotationProcessorException {
        ApplicationClientDescriptor appClient = (ApplicationClientDescriptor)d;
        appClient.getModuleDescriptor().setStandalone(true);
    }

    protected boolean classContainsAnnotation(
            String entry, AnnotationDetector detector, 
            AbstractArchive archive, ApplicationClientDescriptor descriptor) 
            throws FileNotFoundException, IOException {
        JarFile jar = null;
        try {
            jar = new JarFile(archive.getArchiveUri());
            JarEntry mainClassEntry = jar.getJarEntry(entry);
            return detector.containsAnnotation(jar, mainClassEntry);
        } catch (Throwable thr) {
            throw new RuntimeException(localStrings.getString(
                "appclient.errorCheckingAnnos"), thr);
        } finally {
            if (jar != null) {
                try {
                    jar.close();
                } catch (IOException ioe) {
                    throw new RuntimeException(localStrings.getString(
                        "appclient.errorClosingJar", archive.getArchiveUri()), ioe);
                }
            }
        }
    }
}
