/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/**
 *Wrapper around HttpServletRequest used for forwarding requests for the 
 *initial JNLP document for an app client - which arrives at the ad hoc 
 *servlet - off to the system servlet for processing.
 *
 * @author tjquinn
 */
public class JWSAdHocServletRequestWrapper extends HttpServletRequestWrapper {
    
    private String adjustedPathInfo;
    
    /** Creates a new instance of AdHocServletRequestWrapper */
    public JWSAdHocServletRequestWrapper(HttpServletRequest request, String contextRoot, String category) {
        super(request);
        setUserInfo(contextRoot, category);
    }
    
    private void setUserInfo(String contextRoot, String category) {

        adjustedPathInfo = "/" + removeLeadingSlash(category) + "/" + removeLeadingSlash(contextRoot);
    }
    
    /**
     *Returns the adjusted path information for use in the system web app.
     *@return path info reflecting the request category (appclient or application)
     *and the context root indicating which app client is of interest
     */
    public String getPathInfo() {
        return adjustedPathInfo;
    }
    
    /**
     *Removes any leading slash from the path segment.
     *@param path the path from which to remove any leading slash
     *@return the path with any leading slash removed
     */
    private String removeLeadingSlash(String path) {
        String result = null;
        /*
         *Exclude a slash at the beginning of the context root.
         */
        int slash = path.indexOf("/");
        if (slash == 0 && path.length() > 1) {
            result = path.substring(1);
        } else {
            result = path;
        }
        return result;
    }
}
