
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

/** 
 * This is a factory class for the connector admin services classes.
 * @author Srikanth P
 */

public class ConnectorAdminServicesFactory {


    /**
     * Returns a specific connector admin service implemntation class based 
     * on the type of service.
     *
     * @param type Service type. 
     * @return COnnectorAdminService implementation class 
     */

    public static ConnectorAdminService getService(String type) {

        if(type == null) {
            return null;
        }
        if(type.equals(ConnectorAdminService.CCP)) {
            return new ConnectorConnectionPoolAdminServiceImpl();
        } else if(type.equals(ConnectorAdminService.CR)) {
            return new ConnectorResourceAdminServiceImpl();
        } else if(type.equals(ConnectorAdminService.AOR)) {
            return new ConnectorAdminObjectAdminServiceImpl();
        } else if(type.equals(ConnectorAdminService.SEC)) {
            return new ConnectorSecurityAdminServiceImpl();
        } else if(type.equals(ConnectorAdminService.RA)) {
            return new ResourceAdapterAdminServiceImpl();
        } else {
            return null;
        }
    }
}
