/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.authentication;

import com.sun.logging.LogDomains;

import java.util.logging.*;
import java.io.Serializable;


/**
 * This class represents the key for security Maps.
 * This is used as key in storing the backend principals as value in the
 * security map in ConnectorRegistry
 * @author    Srikanth P
 */

public class PrincipalAuthKey implements Serializable {

    private String rarName_ = null;
    private String poolName_ = null;
    private String principalName_ = null;
    private String userGroup_ = null;

    static Logger _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);

    /**
     * Constructor
     * @param rarName  Name of the rar
     * @param poolName Nmae of the pool
     * @param principalName Name of the principal to which security mapping
     *                      is to be done.
     * @param userGroupName  Name of the userGroup to which security mapping
     *                      is to be done.
     */

    public PrincipalAuthKey(String rarName,String poolName,
                        String principalName,String userGroupName){
        rarName_ = rarName;
        poolName_ = poolName;
        principalName_ = principalName;
        userGroup_ = userGroupName;
        _logger.log(Level.FINE,"Constructor: PrincipalAuthKey");
    }

    /**
     *  Generates Hashcode . Overloaded method from "Object" class.
     *  @return hashCode
     */

    public int hashCode() {
        return (rarName_+poolName_+principalName_+userGroup_).hashCode();
    }

    /** Checks whether two strings are equal including the null string 
     *  cases.
     */

    private boolean isEqual(String in, String out) {
        if(in == null && out == null) {
            return true;
        }
        if(in == null || out == null) {
            return false;
        }
        return (out.equals(in));
    }

    /**
     *  Checks for equality.
     *  Overloaded equals()  from Object class. Used when comparing strings 
     *  for equality.
     *  @param other Object to compare
     *  @return true if the objects are equal
     *          false if not so.
     */

    public boolean equals(Object other) {
        if( other == null || !(other instanceof PrincipalAuthKey)) {
            if ( _logger.isLoggable(Level.FINE) ) {
                String msg = "equals method PrincipalAuthKey: parameter not ";
                String msg1= "PrincipalAuthKey. Equals fails";
                _logger.log(Level.FINE,msg+msg1);
            }
	    return false;
        }
        PrincipalAuthKey otherkey = (PrincipalAuthKey)other;

        if(isEqual(this.rarName_,otherkey.rarName_)   && 
                 isEqual(this.poolName_,otherkey.poolName_) && 
                 isEqual(this.principalName_,otherkey.principalName_) &&
                 isEqual(this.userGroup_,otherkey.userGroup_)) {
            _logger.log(Level.FINE,"equal method of PrincipalAuthKey succeeds"); 
            return true;
        } else {
            _logger.log(Level.FINE,"equals method of PrincipalAuthKey fails"); 
            return false;
        }
    }
}
