
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.*;
import com.sun.enterprise.util.*;
import java.io.IOException;
import java.lang.ClassLoader;
import com.sun.logging.LogDomains;
import java.util.logging.*;
import java.io.File;
import java.net.*;


/** 
 * This is an util class to get the ClassLoader pertaining to the 
 * stand alone connector modules.
 * @author Srikanth P
 */

public class ConnectorClassLoaderUtils {

    static Logger _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    
    /**
     *  Obtains the class loader. The Connector class loader is a
     *  singleton instance. The directory where rar is exploded  is
     *  added to the classloader path before returing the instance.
     *  @param moduleDir Directory where rar is exploded 
     *  @return connector Classloader instance 
     */

    public static ClassLoader getClassLoader(String moduleDir) {
        try {
            ClassLoader jcl = null;
            jcl = ConnectorClassLoader.getInstance();
            File f = new File(moduleDir);
                       ((ConnectorClassLoader)jcl).appendURL(f);
            return jcl;
        } catch (IOException ex) {
            _logger.log(Level.SEVERE,
                     "rardeployment.malfarmed_url_for_classloader",moduleDir);
        }
        return null;
    }
}
