
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

import java.util.*;
import com.sun.enterprise.connectors.*;
import com.sun.enterprise.deployment.*;


/** Interface class of connector configuration parser methods. 
 *  Implemented by specific configuration parser classes.
 *  @author Srikanth P
 */

public interface ConnectorConfigParser {

    /** 
     * Admin object type.
     */

    String AOR = "AdminObject";

    /** 
     * Managed connection factory type.
     */

    String MCF = "ManagedConnectionFactory";

    /** 
     * Resource adapter type.
     */

    String RA =  "ResourceAdapter";

    /** 
     * Message listener type.
     */

    String MSL =  "MessageListener";

    /**
     * Instances of util classes. Used as composition pattern.
     */
    ConnectorDDTransformUtils ddTransformUtil = new ConnectorDDTransformUtils();
    ConnectorConfigParserUtils configParserUtil = 
                            new ConnectorConfigParserUtils();

    /**
     * Obtains the merged javabean properties (properties present in ra.xml 
     * and introspected properties) of a specific configuration. 
     * @param desc ConnectorDescriptor pertaining to rar .
     * @param connectionDefName Connection definition name or 
     *                          admin object interface .
     * @return Merged properties.
     */

    Properties getJavaBeanProps(ConnectorDescriptor desc, 
            String connectionDefName, String rarName) throws ConnectorRuntimeException; 
}
