
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

/** 
 * This is a factory class for the connector configuration parser classes.
 * @author Srikanth P
 */

public class ConnectorConfigParserFactory {


    /**
     * Returns a specific connector configuration parser class based on the 
     * type of configurations to parse.
     *
     * @param type Parser class type. 
     * @return parser class
     */

    public static ConnectorConfigParser getParser(String type) {

        if(type == null) {
            return null;
        }
        if(type.equals(ConnectorConfigParser.AOR)) {
            return new AdminObjectConfigParserImpl();
        } else if(type.equals(ConnectorConfigParser.MCF)) {
            return new MCFConfigParserImpl();
        } else if(type.equals(ConnectorConfigParser.RA)) {
            return new ResourceAdapterConfigParserImpl();
        } else if(type.equals(ConnectorConfigParser.MSL)) {
            return new MessageListenerConfigParserImpl();
        } else {
            return null;
        }
    }
}
