/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.work;

import com.sun.enterprise.util.Utility;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.WorkManager;
import com.sun.enterprise.util.i18n.StringManager;

/**
 * WorkManagerFactory allows other customized WorkManager implementation
 * to be plugged into the server.  The name of the customized 
 * implementation class for the WorkManager has to be specified as
 * a system property "workmanager.class".
 * <p>
 * It is assumed that the implementation for WorkManager also provides
 * a public method called "getInstance" that returns a WorkManager object.
 * This frees the WorkManagerFactory from deciding whether WorkManager
 * is implemented as a Singleton in the server.
 * <p>
 * @author	Qingqing Ouyang, Binod P.G.
 */
public class WorkManagerFactory {
    
    private static final String DEFAULT = 
    "com.sun.enterprise.connectors.work.CommonWorkManager";
    
    private static final String WORK_MANAGER_CLASS = "workmanager.class";
    
    private static Logger logger = 
    LogDomains.getLogger(LogDomains.RSR_LOGGER);
 
    private static StringManager localStrings = 
                        StringManager.getManager(WorkManagerFactory.class);
   
    /**
     * This is called by the constructor of BootstrapContextImpl
     */
    public static WorkManager getWorkManager(String poolName) 
                              throws ConnectorRuntimeException {
        
        String className = null;
        String methodName = "getInstance";
        Class cls = null;
        WorkManager wm = null;
        
        try {
            className = System.getProperty(WORK_MANAGER_CLASS, DEFAULT);

            // Default work manager implementation is not a singleton.
            if (className.equals(DEFAULT)) {
                return new CommonWorkManager(poolName);
            }
            
            cls = Class.forName(className);
            if (cls != null) {
                Method method = cls.getMethod("getInstance", new Class[]{});
                wm = (WorkManager) method.invoke(cls, new Object[] {});
            }
        } catch (Exception e) {
            String msg = localStrings.getString("workmanager.instantiation_error");
            logger.log(Level.SEVERE, msg, e);
        }
        
        return wm;
    }

}
