/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployapi.actions;

import java.io.*;

import javax.enterprise.deploy.spi.exceptions.ClientExecuteException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.TargetModuleID;

import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.util.LocalStringManagerImpl;


/**
 * This implementation of the ClientConfiguration interface allow
 * for limited support of Application Client
 *
 * @author Jerome Dochez
 */
public class ClientConfigurationImpl implements ClientConfiguration {
    
    SunTargetModuleID targetModuleID;
    String originalArchivePath;
    
    private static LocalStringManagerImpl localStrings =
	  new LocalStringManagerImpl(ClientConfigurationImpl.class);    
    
    /** Creates a new instance of ClientConfigurationImpl */
    public ClientConfigurationImpl(SunTargetModuleID targetModuleID) {
        this.targetModuleID = targetModuleID;
    }
                
    /** This method performs an exec and starts the
     * application client running in another process.
     *
     * @throws ClientExecuteException when the configuration
     *         is incomplete.
     */
    public void execute() throws ClientExecuteException {
        if (targetModuleID==null) {
            throw new ClientExecuteException(localStrings.getLocalString(
                "enterprise.deployapi.actions.clientconfigurationimpl.nomoduleid", 
                "No moduleID for deployed application found"));
        }
        SunTarget target = (SunTarget) targetModuleID.getTarget();
        String moduleID;
        if (targetModuleID.getParentTargetModuleID()!=null) {            
            moduleID = targetModuleID.getParentTargetModuleID().getModuleID();
        } else {
            moduleID = targetModuleID.getModuleID();
        }
        
        
        try {
            // retrieve the stubs from the server
            String location = target.exportClientStubs(moduleID, 0,  System.getProperty("java.io.tmpdir"));
       
            // get the module id for the appclient
            String id = targetModuleID.getModuleID();
            if (id.indexOf('#')!=-1) {
                id = id.substring(id.indexOf('#')+1);
            }
        
            // invoke now the appclient...
            String j2eeHome = System.getProperty("com.sun.aas.installRoot");
            String appClientBinary = j2eeHome + File.separatorChar + "bin" + File.separatorChar + "appclient";
            String command = appClientBinary + " -client " + location;
            
            Process p = Runtime.getRuntime().exec(command);
            InputStream is = p.getInputStream();
            
        } catch(Exception e) {
            e.printStackTrace();
            throw new ClientExecuteException(localStrings.getLocalString(
                "enterprise.deployapi.actions.clientconfigurationimpl.exception", 
                "Exception while invoking application client : \n {0}", new Object[] { e.getMessage() }));
        }
    }
}
