/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/* 
 * ConnectorModuleDeployer.java
 *
 * Created on January 15, 2002, 3:37 PM
 * 
 * @author  bnevins
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/backend/ConnectorModuleDeployer.java,v $
 *
 */

package com.sun.enterprise.deployment.backend;

import java.io.IOException;
import java.io.File;
import java.util.logging.Level;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils; 
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.zip.ZipFileException;

public class ConnectorModuleDeployer extends ModuleDeployer
{
	ConnectorModuleDeployer(DeploymentRequest r) throws IASDeploymentException
	{
		super(r);
	}

	///////////////////////////////////////////////////////////////////////////

	protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) 
            throws IASDeploymentException, ConfigException
	{
        connModulesMgr = new ConnectorModulesManager(ienv);
		return connModulesMgr;
	}
	
    	/**
	 * @return the module classpath
	 */
	protected List getModuleClasspath(Archivist archivist,
                AbstractArchive archive) throws IASDeploymentException {
	    
	    return new ArrayList();
	}
	
	///////////////////////////////////////////////////////////////////////////

	protected void preDeploy() throws IASDeploymentException
	{
		assert moduleDir != null;
		assert StringUtils.ok(moduleName);

		try
		{
			if(isRegistered()) {
				String msg = localStrings.getString(
					"enterprise.deployment.backend.deploy_error_module_exists");
				throw new IASDeploymentException( msg );
			}

			// if the directories already exist on disk -- wipe them out
			// We do this because otherwise they'd never get this Module deployed
			// without wiping the dirs manually
			liquidateModuleDirAndStubsDirIfTheyHappenToExist();
			
			if(request.isArchive())
			{
				J2EEModuleExploder.explode(request.getFileSource().getFile(), moduleDir, moduleName);
			}
                        xmlDir.mkdirs();
		}
		catch(Exception e)
		{
			throw new IASDeploymentException(e.toString(), e);
		}
	}
	
	///////////////////////////////////////////////////////////////////////////

	protected void preRedeploy() throws IASDeploymentException, ConfigException
	{
		setOldDirs();

		if(request.isArchive())
                {
                    try
			{
			    J2EEModuleExploder.explode(request.getFileSource().getFile(), moduleDir, moduleName);

			}
			catch(IOException e)
			{
				throw new IASDeploymentException(e.toString(), e);
			}
		}
		
                xmlDir.mkdirs();
	}
	
	///////////////////////////////////////////////////////////////////////////

	protected void deploy() throws IASDeploymentException, ConfigException
	{
            runVerifier();

            try {
                // copy xml files to generated/xml directory
                // this work around should be removed once connector team
                // provide a unified way to copy necessary files to
                // generated/xml directroy.
      	        String appDir = 
                    request.getDeployedDirectory().getCanonicalPath();
	        String generatedXMLDir = 
                    request.getGeneratedXMLDirectory().getCanonicalPath();

 	        FileArchive srcArchive = new FileArchive();
 	        srcArchive.open(appDir);
 			
     	        FileArchive destArchive = new FileArchive();
 	        destArchive.open(generatedXMLDir); 

                Archivist.copyExtraElements(srcArchive, destArchive);
	    } catch (Exception e) {
                throw new IASDeploymentException(e.getCause());
            }
        }
        // END OF IASRI 4686190

    private			ConnectorModulesManager connModulesMgr	= null;
    private static	StringManager			localStrings	= StringManager.getManager(ConnectorModuleDeployer.class);
}

