/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.backend;

import java.io.File; 
import java.io.FileInputStream; 
import java.io.IOException;
import java.util.logging.Level;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.DOLLoadingContextFactory;

import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;

public class DOLLoadingContext {
    private static final String DEFAULT_WEB_XML = "default-web.xml";

    /**
     * initialize the default WebBundleDescriptor from
     * default-web.xml
     */
    public static WebBundleDescriptor initDefaultWebBundleDescriptor() {
        DOLLoadingContextFactory.setParsingDefaultWebXML(true);

        FileInputStream fis = null; 

        WebBundleDescriptor wbd = null;
        try {
            // parse default-web.xml contents 
            // (this path will not be invoked by portable static verifier)
            if (ApplicationServer.getServerContext() != null) {
                InstanceEnvironment iEnv = ApplicationServer.getServerContext(
                    ).getInstanceEnvironment();

                String defaultWebXMLPath = iEnv.getConfigDirPath() + 
                    File.separator + DEFAULT_WEB_XML;
                File file = new File(defaultWebXMLPath);
                if (file.exists()) {
                    fis = new FileInputStream(file);
                    WebDeploymentDescriptorFile wddf = 
                        new WebDeploymentDescriptorFile();
                    wddf.setXMLValidation(false);
                    wbd =  (WebBundleDescriptor) wddf.read(fis);
                }
            }
            return wbd;
        } catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, 
                "enterprise.deployment.default.web.xml.not.parsed", 
                 new Object[] {e.getMessage()});
            return null;
        } finally {
            DOLLoadingContextFactory.setParsingDefaultWebXML(false);
            try {
                if (fis != null) {
                    fis.close();
                }
            } catch (IOException ioe) {
                // do nothing
            }
        }
    }
}
