/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.interfaces;

/**
 * Constants used in different parts of the deployment implementation
 *
 * @author  Jerome ochez
 */
public interface DeploymentImplConstants {
    
    public static final String ClientJarSuffix = "Client.jar";
    /*
     * Use this property to select the desired client jar genration senario.
     * Possible values are:
     * "transition" : current default. use the new simple applient jar maker
     *                when appropriate.  otherwise, defer to the original one.
     * "combo"      : near future default. use the new simple appclient jar 
     *                maker when appropriate.  otherwise, defer to new ear 
     *                appclient maker
     * "ear"        : use only the new ear appclient make
     * "original"   : use the original implementation (to verify regression)
     */
    public static final String 
        CLIENT_JAR_MAKER_CHOICE = "client.jar.maker.choice";

    /*
     * Internal implementation constant.  NOT a supported system property.
     */
    public static final String 
        USE_MODULE_CLIENT_JAR_MAKER = "use.module.client.jar.maker";
}
