/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentContext.java
 *
 * Created on May 22, 2003, 2:26 PM
 * @author  sandhyae
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/phasing/DeploymentContext.java,v $
 *
 */

package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.util.i18n.StringManager;

/**
 * This class is used to pass the common context needed by all deployment phases
 * @author Sandhya E
 */
public class DeploymentContext {
    
    /** 
     * Creates a new instance of DeploymentContext
     */
    public DeploymentContext() 
    {
    }
    
    /**
     * Set the config context as specified
     * @param configContext config context object
     */
    public void setConfigContext(ConfigContext configContext)
    {
        this.configContext = configContext;
    }
    
    /**
     * returns the stored configContext
     * @return configContext
     */
    public ConfigContext getConfigContext() 
    {
        return configContext;
    }
    
    /** config context */
    private ConfigContext configContext = null;
    
}
