/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import java.util.logging.Level;
import java.io.File;

/**
 * Holds all defaults for service config
 * @author mu125243
 */
public interface Defaults {
    
    public static final int MAX_NO_OF_ENTRIES = 500;
    public static final int MIN_LOG_LEVEL = Level.INFO.intValue();
    public static final String LOG_FILE = "${com.sun.aas.instanceRoot}" +
            File.separator + "logs" + File.separator + 
            "server.log" + File.separator;
    public static final String LOGS = "logs";
    public static final String DEST_LOG_FILE = File.separator + LOGS +
            File.separator + "server.log";
    public static final String TEMP_REPORT = "reports_temp";
    public static final String TEMP_REPORT_FOLDER = File.separator + 
            TEMP_REPORT;
    public static final String DIAGNOSTIC_REPORT  = "diagnostic-reports";
    public static final String REPORT_FOLDER = File.separator +  
            DIAGNOSTIC_REPORT;
    public static final String CHECKSUM_FILE_NAME= File.separator + "checksum";
    public static final String DOMAIN_XML_VERIFICATION_OUTPUT= File.separator +
            "domain-xml-verification";
    public static final String CUSTOMER_INPUT = File.separator + "customer-input";
    public static final String MONITORING_INFO_FILE = "MonitoringInformation";
    public static final String SYSTEM_INFO_FILE = File.separator +
            "SystemInformation";
    public static final String HADB_INFO_FILE = File.separator +
            "HADBInformation";
    public static final String REPORT_NAME = File.separator + "ReportSummary.html";
}
