/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import java.util.Map;
import java.util.HashMap;

/**
 * Responsible for creating ServiceConfig object per configuration in
 * domain.xml
 * @author mu125243
 */
public class ServiceConfigFactory {
    
    /**
     * Map between a config and it's diagnostic service configuration.
     * Multiple instances may be using same configuration in which case
     * there is only one ServiceConfig object for those instances.
     */
    private static Map diagnosticServiceConfigs;
    
    /**
     * instance name to config name map
     */
    private static Map instanceConfigMap;
    
    /**
     * Config with default values 
     */
    private static ServiceConfig defaultConfig;
    
    private static ServiceConfigFactory configFactory;
    
    /** Creates a new instance of ServiceConfigFactory */
    private ServiceConfigFactory() {
        diagnosticServiceConfigs = new HashMap(5);
        instanceConfigMap = new HashMap(5);
    }
    
    /**
     * Returns a ServiceConfgiFactory object
     * @return ServiceConfigFactory
     */ 
    public static ServiceConfigFactory getInstance() {
        if (configFactory == null)
            configFactory = new ServiceConfigFactory();
        
        return configFactory;
    }
    
    /**
     * @return ServiceConfig with default values
     */
    public static ServiceConfig getDefaultServiceConfig() {
            if( defaultConfig == null) {
                defaultConfig = new ServiceConfig(true,true, true, 
                    true,true, true, Defaults.MIN_LOG_LEVEL, 
                    Defaults.MAX_NO_OF_ENTRIES, Defaults.LOG_FILE, null, null);
                return defaultConfig;
            }
        return null;
    }
    
    /**
     * Gets service config for a instance.
     * @param instanceName instance name
     * @return diagnostic-service configuration
     */
    public ServiceConfig getServiceConfig(String instanceName) {
        if (instanceName != null) {
            String configName = (String)instanceConfigMap.get(instanceName);
            return (ServiceConfig)diagnosticServiceConfigs.get(configName);
        }
        return null;
    }
    
    /**
     * Gets diagnostic-service configuration
     * @param local flag which indicates whether command is run in local or remote
     * @param repositoryRoot local/central repository root
     * @param instanceName name of the instance
     * @return diagnostic-service configuration for a instance
     *
     */
    public ServiceConfig getServiceConfig(boolean local, String repositoryRoot,
            String instanceName) {
        if (repositoryRoot != null && instanceName != null) {
            try {
                
                ServiceConfig config = new ServiceConfig(local, 
                        repositoryRoot, instanceName);
                return config;
            }catch(Exception de) {
                // If for some reason diagnostic-service element in domain.xml
                // is not readable, return diagnostic information with 
                // default values. 
                return getDefaultServiceConfig();
            }
        }
        return null;
    }
}
