/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.Harvester;
import com.sun.enterprise.diagnostics.report.html.HTMLReportWriter;
import com.sun.logging.LogDomains;

import java.util.Map;
import java.util.List;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.logging.Level;
/**
 *
 * @author mu125243
 */
public abstract class SingleInstanceObjectFactory implements BackendObjectFactory {
    
    protected Map input;
    protected CLIOptions options;
    protected ReportConfig config;
    protected ReportTarget target;
    protected ExecutionContext context;
    protected Logger logger = LogDomains.getLogger(LogDomains.ADMIN_LOGGER);
    /** Creates a new instance of BackendObjectFactory */
    public SingleInstanceObjectFactory(Map input) {
        this.input = input;
    }
 
   
    public ReportGenerator createReportGenerator() throws DiagnosticException {
        analyzeInput();
        Collector harvester = createHarvester();
        HTMLReportWriter reportWriter = createHTMLReportWriter();
        return createReportGenerator(config,harvester,reportWriter);
    }

    public abstract ReportGenerator createReportGenerator(ReportConfig config,
            Collector harvester,HTMLReportWriter reportWriter)
            throws DiagnosticException;

    public abstract Collector createHarvester() throws DiagnosticException;
    
    public abstract HTMLReportWriter createHTMLReportWriter() 
    throws DiagnosticException ;
    
    public abstract TargetResolver createTargetResolver(boolean local)
    throws DiagnosticException;
    
    protected ReportConfig getReportConfig() {
        return config;
    }
    
    protected  void analyzeInput()  throws DiagnosticException{
        if(input != null) {
            TargetResolver resolver = null;
            boolean local;
            List<ServiceConfig> serviceConfigs = null;
            
            options = new CLIOptions(input);
            local = isLocal();
            resolver = createTargetResolver(local);
            target = resolver.resolve();
            context = resolver.getExecutionContext();
            serviceConfigs = resolver.getServiceConfigs();
            logger = context.getLogger();
            config = new ReportConfig(options, target,context);
            config.addInstanceConfigs(serviceConfigs);
        }
    }
    
    protected boolean isLocal() {
        if(options.isLocal() && (options.getTargetDir() != null) )
            return true;
        return false;
    }
}
