/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.util;

import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ApplicationServer;
/**
 * Helper to get instance specific runtime information
 * @author Manisha Umbarje
 */
public class DiagnosticServiceHelper {
    
    public static final String OS_NAME="os.name";
    public static final String SUN ="sun";
    public static final String LINUX = "linux";
    
    public static String getInstallationRoot() {
            return System.getProperty("com.sun.aas.installRoot");
    }
    
    public static String getInstanceRoot() {
        try {
            return ApplicationServer.getServerContext().getInstallRoot();
        } catch (Exception e) {
            return System.getProperty("com.sun.aas.instanceRoot");
        }
    }
    public static String getConfigLocation() {
	return ApplicationServer.getServerContext().getServerConfigURL();
    }

    public static String getInstanceName() {
	return ApplicationServer.getServerContext().getInstanceName();
    }
    
    public static boolean isSolaris() {
        String osName = (System.getProperty(OS_NAME)).toLowerCase();

        if(osName.startsWith(SUN) || osName.startsWith(LINUX))
            return  true;
        return false;
    }
    
}
