/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop;

import org.omg.CosNaming.*;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.Encoding;
import org.omg.IOP.ENCODING_CDR_ENCAPS;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;

import java.util.logging.*;
import com.sun.logging.*;

/**
 * This class is used to add IOR interceptors for supporting IN_ADDR_ANY
 * functionality in the ORB
 */
public class IORAddrAnyInitializer extends org.omg.CORBA.LocalObject 
                                implements ORBInitializer{
                                    
    private static Logger _logger=null;
    static {
       _logger=LogDomains.getLogger(LogDomains.CORBA_LOGGER);
    }
    
    public static final String baseMsg = IORAddrAnyInitializer.class.getName();
    
    /** Creates a new instance of IORAddrAnyInitializer */
    public IORAddrAnyInitializer() {
    }
    
    /**
     * Called during ORB initialization.  If it is expected that initial
     * services registered by an interceptor will be used by other
     * interceptors, then those initial services shall be registered at
     * this point via calls to
     * <code>ORBInitInfo.register_initial_reference</code>.
     *
     * @param info provides initialization attributes and operations by
     *    which Interceptors can be registered.
     */
    public void pre_init(org.omg.PortableInterceptor.ORBInitInfo info) {
    }
    
    /**
     * Called during ORB initialization. If a service must resolve initial
     * references as part of its initialization, it can assume that all
     * initial references will be available at this point.
     * <p>
     * Calling the <code>post_init</code> operations is not the final
     * task of ORB initialization. The final task, following the
     * <code>post_init</code> calls, is attaching the lists of registered
     * interceptors to the ORB. Therefore, the ORB does not contain the
     * interceptors during calls to <code>post_init</code>. If an
     * ORB-mediated call is made from within <code>post_init</code>, no
     * request interceptors will be invoked on that call.
     * Likewise, if an operation is performed which causes an IOR to be
     * created, no IOR interceptors will be invoked.
     *
     * @param info provides initialization attributes and
     *    operations by which Interceptors can be registered.
     */
    public void post_init(org.omg.PortableInterceptor.ORBInitInfo info) {
        Codec codec = null;
        CodecFactory cf = info.codec_factory();
  
        byte major_version = 1;
        byte minor_version = 2;
        Encoding encoding = new Encoding(ENCODING_CDR_ENCAPS.value, 
                                         major_version, minor_version);
        try {
            codec = cf.create_codec(encoding);
        } catch (org.omg.IOP.CodecFactoryPackage.UnknownEncoding e) {
            _logger.log(Level.WARNING,"UnknownEncoding from " + baseMsg,e);
	    }
        try {
            info.add_ior_interceptor(new IORAddrAnyInterceptor(codec));
        } catch (DuplicateName ex) {
            _logger.log(Level.WARNING,"DuplicateName from " + baseMsg,ex);
        }
    }
    
}
