/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.selfmanagement.reconfig;

import com.sun.enterprise.management.selfmanagement.SelfManagementService;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEvent;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEventListener;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEvent;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEventListener;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigSet;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ManagementRules;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.Action;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Server;

import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * This class handles dynamic reconfiguration notification related to 
 * management-rule creation, update and deletion.
 *
 * @author Pankaj Jairath
 */ 
public class ManagementRuleReconfig implements ManagementRuleEventListener{
    
    private static SelfManagementService service = 
                                 SelfManagementService.getService();
    
    /** Logger for self management service */
    private static Logger _logger =  null;
    
    static {
        _logger = LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
    }    
    
    /**
     * Create a new management-rule 
     */
    public void handleCreate(ManagementRuleEvent event)
                                            throws AdminEventListenerException {
        _logger.log(Level.FINE,"sgmt.reconfig_handlecreatereceived");
        
        try{             
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            ConfigAdd configAdd = null;
            ConfigChange configChange = null;
            ArrayList<ConfigChange> configChangeList = event.getConfigChangeList();
            ManagementRule rule = null;
            String xpath = null;
            String pXPath = null;
            Object object;
            
            for (int i=0; i < configChangeList.size(); i++){
                configChange = configChangeList.get(i);
                if (configChange instanceof ConfigAdd) {
                    _logger.log(Level.INFO,"sgmt.reconfig_handlecreaterulereceived");
                    xpath = configChange.getXPath();
                    // 
                    if (xpath != null) {
                        _logger.log(Level.INFO, "sgmt.reconfig_handlexpath",xpath);
                        rule = (ManagementRule)configContext.exactLookup(xpath);
                        if (rule.isEnabled()) {
                            service.addRule(rule, configContext); 
                        } else {
                            service.addDisabledRule(rule);
                        }
                    }
                } else if(configChange instanceof ConfigSet) {
                    //handle action addition
                    pXPath = configChange.getParentXPath();
                    String name = configChange.getName();
                    if (name.equals(ManagementRule.ACTION)) {
                        _logger.log(Level.INFO,"smgt.handleactionadd",pXPath);
                        rule = (ManagementRule)configContext.exactLookup(pXPath);
                        service.handleActionAdd(rule, configContext);
                    }
                }
            }
        } catch (Exception ex) {
           throw new AdminEventListenerException(ex);
        }  
    }
    
    
    /**
     * Update an existing management-rule.
     */
    public void handleUpdate(ManagementRuleEvent event)
                                            throws AdminEventListenerException {   
        _logger.log(Level.INFO,"sgmt.reconfig_handleupdatereceived");                         

        try {
            ConfigContext configContext = event.getConfigContext();
            ConfigContext oldConfigContext = event.getOldConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            ConfigUpdate configUp = null;
            ArrayList<ConfigUpdate> configChangeList = event.getConfigChangeList();
            String xPath = null;
            Object object;

            for (int i=0; i < configChangeList.size(); i++){
                configUp = configChangeList.get(i);

                xPath = configUp.getXPath();
                if (xPath!=null) {
                    _logger.log(Level.INFO,"sgmt.handleupdatexpath", xPath);
                    object = configContext.exactLookup(xPath);
                    if (object instanceof ManagementRules) {
                        ManagementRules rules = (ManagementRules)object;
                        service.handleRulesUpdate(configContext,configUp);
                    } else if(object instanceof ManagementRule) {
                        ManagementRule rule = (ManagementRule)oldConfigContext.exactLookup(xPath); 
                        service.handleRuleUpdate(rule,configUp,configContext);
                    } else if (object instanceof Action) {
                        String pXPath = xPath.substring(0,xPath.lastIndexOf("/"));;
                        ManagementRule rule = (ManagementRule)configContext.exactLookup(pXPath);
                        service.handleActionUpdate(rule,configUp);
                    }
                 }
            }
                     
       
        } catch (Exception ex) {
           throw new AdminEventListenerException(ex);
        }
 
    }
    
    
    /**
     * Delete an existing management-rule. 
     */
    public void handleDelete(ManagementRuleEvent event) 
                                           throws AdminEventListenerException {
        _logger.log(Level.INFO,"sgmt.reconfig_handledeletereceived");                         
        try{
            ConfigContext configContext = event.getOldConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            ConfigDelete configDel = null;
            ArrayList<ConfigDelete> configChangeList = event.getConfigChangeList();
            ManagementRule rule = null;
            String xpath = null;
            Object object;

            for (int i=0; i < configChangeList.size(); i++){
                configDel = configChangeList.get(i);

                xpath = configDel.getXPath();
                if (xpath != null){
                    _logger.log(Level.INFO, "sgmt.reconfig_handledelxpath",xpath);
                    //rule = (ManagementRule)configContext.exactLookup(xpath);
                    object = configContext.exactLookup(xpath); 
                    if (object instanceof Action) {
                        //handle action removal - noaction
                    } else if (object instanceof ManagementRule) {
                        rule = (ManagementRule)object;
                        String ruleName = rule.getName();
                        service.deleteRule(ruleName);
                    }
                }
            }
        }  catch( Exception ex){
           throw new AdminEventListenerException(ex);
        }      
    }     
}
