/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;
import java.util.*;
import com.sun.enterprise.util.Utility;

/**
 * Resource info for JDBC XA DataSources.
 *
 * @author Kenneth Saks
 */ 
public class IASJdbcXAResource extends JdbcXAResource {
    
    private JdbcConnectionPool jdbcConnectionPool_;
    
    public IASJdbcXAResource(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        IASJdbcXAResource clone = new IASJdbcXAResource(name);
        clone.setEnabled(isEnabled());
        clone.setDescription(getDescription());
        clone.setJdbcConnectionPool(getJdbcConnectionPool());
        return clone;
    }


    public String getUserName() {
        return getJdbcConnectionPool().getUserName();
    }
    
    public String getPassword() {
        return getJdbcConnectionPool().getPassword();
    }
    
    public String getClassname() {
        return getJdbcConnectionPool().getDatasourceClassname();
    }

    public void setClassname(String classname) {
        getJdbcConnectionPool().setDatasourceClassname(classname);
    }    
    
    public JdbcConnectionPool getJdbcConnectionPool() {
        return jdbcConnectionPool_;
    }
    
    public void setJdbcConnectionPool(JdbcConnectionPool jdbcConnectionPool) {
        jdbcConnectionPool_ = jdbcConnectionPool;   
    }

    public Set getProperties() {
        return getJdbcConnectionPool().getProperties();
    }
    
    public void addProperty(ResourceProperty property) {
        getJdbcConnectionPool().addProperty(property);
    }

    public boolean removeProperty(ResourceProperty property) {
        return getJdbcConnectionPool().removeProperty(property);
    }

    public ResourceProperty getProperty(String propertyName) {
        return getJdbcConnectionPool().getProperty(propertyName);
    }
    
    public String toString() {
        String propsString = getPropsString();
        return "< IAS JDBC XA Resource : " + getName() +
            ((propsString.length() > 0) ? 
             propsString : "No properties") + " >";
    }
}
