/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.*;

/**
 * Concrete implementation class for J2EEResourceCollection.
 *
 * @author Kenneth Saks
 */ 
public class J2EEResourceCollectionImpl implements J2EEResourceCollection {

    private Map resourceSets_;

    public J2EEResourceCollectionImpl() {
        resourceSets_ = new HashMap();
    }

    public Set getResourcesByType(int type) {
        Map resourceSet = getResourcesInternal(type);
        Collection collection = resourceSet.values();
        Set shallowCopy = new HashSet();
        for(Iterator iter = collection.iterator(); iter.hasNext();) {
            J2EEResource next = (J2EEResource) iter.next();
            shallowCopy.add(next);
        }
        return shallowCopy;
    }
    
    public Set getAllResources() {
        Set allResources = new HashSet();
        Collection resourcesByType = resourceSets_.values();
        for(Iterator iter = resourcesByType.iterator(); iter.hasNext(); ) {
            HashMap next = (HashMap) iter.next();
            allResources.addAll(next.values());
        }
        return allResources;
    }

    public void addResource(J2EEResource resource) {
        Map resourceSet = getResourcesInternal(resource.getType());
        resourceSet.put(resource.getName(), resource);
    }

    public boolean removeResource(J2EEResource resource) {
        Map resourceSet = getResourcesInternal(resource.getType());
        boolean removed = 
            (resourceSet.remove(resource.getName()) != null);
        return removed;
    }

    public void removeAllResourcesByType(int type) {
        resourceSets_.remove(new Integer(type));
    }

    public J2EEResource getResourceByName(int type, String resourceName) {
        Map resourceSet = getResourcesInternal(type);
        return (J2EEResource) resourceSet.get(resourceName);
            
    }

    private Map getResourcesInternal(int type) {
        Map resourceSet = (Map) resourceSets_.get(new Integer(type));
        if( resourceSet == null ) {
            resourceSet = new HashMap();
            resourceSets_.put(new Integer(type), resourceSet);
        }
        return resourceSet;
    }

}
