/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;
import java.util.*;
import com.sun.enterprise.util.Utility;
// IASRI 4660742 START
import java.util.logging.*;
import com.sun.logging.*;
// IASRI 4660742 END

/**
 * Resource info for JDBC XA DataSources.
 *
 * @author Kenneth Saks
 */ 
public class JdbcXAResource extends J2EEResourceBase implements Serializable {

// IASRI 4660742 START
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.ROOT_LOGGER);
        }
// IASRI 4660742 END
    private String classname_;
    private String dbuser_;
    private String dbpassword_;
    
    public JdbcXAResource(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        JdbcXAResource clone = new JdbcXAResource(name);
        clone.setClassname(getClassname());
        clone.setDbuser(getDbuser());
        clone.setDbpassword(getDbpassword());
        return clone;
    }

    public int getType() {
        return J2EEResource.JDBC_XA_RESOURCE;
    }

    public String getClassname() {
        return classname_;
    }

    public void setClassname(String classname) {
        classname_ = classname;
    }

    public String getDbuser() {
        return dbuser_;
    }

    public void setDbuser(String dbuser) {
        dbuser_ = dbuser;
    }

    public String getDbpassword() {
        return dbpassword_;
    }

    public void setDbpassword(String dbpassword) {
        dbpassword_ = dbpassword;
    }

    // start IASRI 4659935
    // Moved this method to JdbcConnectionPool
    /*
    public Object createDataSource() throws J2EEResourceException {
        Object dataSource = null;
        try {
            Class dataSourceClass = Class.forName(getClassname());
            dataSource = dataSourceClass.newInstance();
            for(Iterator iter = getProperties().iterator(); iter.hasNext(); ){
                ResourceProperty next = (ResourceProperty) iter.next();
                Utility.invokeSetMethod(dataSource, next.getName(), 
                                        next.getValue().toString());
            }
        } catch(Exception e) {
// IASRI 4660742            e.printStackTrace();
// START OF IASRI 4660742
		_logger.log(Level.SEVERE,"enterprise.datasource_exception",e);
// END OF IASRI 4660742
            throw new J2EEResourceException(e);
        }
        return dataSource;
    }
    */
    // end IASRI 4659935

    public String toString() {
        String propsString = getPropsString();
        return "< JDBC XA Resource : " + getName() + 
            " , " + getClassname() + " , " + getDbuser() +
            " , " + getDbpassword() + " , " +
            ((propsString.length() > 0) ? 
             propsString : "No properties") + " >";
    }
}
