/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;
import com.sun.enterprise.deployment.interfaces.MailResourceIntf;

/**
 * Resource info for MailResource.
 * IASRI #4650786
 * @author James Kong
 */
public class MailResource   extends J2EEResourceBase
                            implements Serializable, MailResourceIntf {
    
    private String resType_;
    private String factoryClass_;

    private String storeProtocol_;
    private String storeProtocolClass_;
    private String transportProtocol_;
    private String transportProtocolClass_;
    private String mailHost_;
    private String username_;
    private String mailFrom_;
    private boolean debug_;
    
    public MailResource(String name) {
        super(name);
    }
    
    protected J2EEResource doClone(String name) {
        MailResource clone = new MailResource(name);
        clone.setResType(getResType());
        clone.setFactoryClass(getFactoryClass());
        return clone;
    }
    
    public int getType() {
        return J2EEResource.MAIL_RESOURCE;
    }
    
    public String getResType() {
        return resType_;
    }
    
    public void setResType(String resType) {
        resType_ = resType;
    }
    
    public String getFactoryClass() {
        return factoryClass_;
    }
    
    public void setFactoryClass(String factoryClass) {
        factoryClass_ = factoryClass;
    }

    public String getStoreProtocol() {
        return storeProtocol_;
    }
    
    public void setStoreProtocol(String storeProtocol) {
        storeProtocol_ = storeProtocol;
    }
    
    public String getStoreProtocolClass() {
        return storeProtocolClass_;
    }
    
    public void setStoreProtocolClass(String storeProtocolClass) {
        storeProtocolClass_ = storeProtocolClass;
    }
    
    public String getTransportProtocol() {
        return transportProtocol_;
    }
    
    public void setTransportProtocol(String transportProtocol) {
        transportProtocol_ = transportProtocol;
    }
    
    public String getTransportProtocolClass() {
        return transportProtocolClass_;
    }
    
    public void setTransportProtocolClass(String transportProtocolClass) {
        transportProtocolClass_ = transportProtocolClass;
    }
    
    public String getMailHost() {
        return mailHost_;
    }
    
    public void setMailHost(String mailHost) {
        mailHost_ = mailHost;
    }
    
    public String getUsername() {
        return username_;
    }
    
    public void setUsername(String username) {
        username_ = username;
    }
    
    public String getMailFrom() {
        return mailFrom_;
    }
    
    public void setMailFrom(String mailFrom) {
        mailFrom_ = mailFrom;
    }
    
    public boolean isDebug() {
        return debug_;
    }
    
    public void setDebug(boolean debug) {
        debug_ = debug;
    }
    
    public String toString() {
        return "< Mail Resource : " + getName() + " , " + getResType() + "... >";
    }
}
