/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.repository;

import javax.naming.RefAddr;

/**
 *
 * @author Qingqing Ouyang
 *
 * @see RefAddr
 * @see StringRefAddr
 * @since 1.3
 */

public class SerializableObjectRefAddr extends RefAddr {
    /**
     * Contains the contents of this address.
     * Can be null.
     * @serial
     */
    private Object contents;
    /**
      * Constructs a new instance of SerializableObjectRefAddr 
      * using its address type and contents.
      *
      * @param addrType A non-null string describing the type of the address.
      * @param contents The possibly null contents of the address in the 
      *                 form of a string.
      */
    public SerializableObjectRefAddr (String addrType, Object contents) {
	super(addrType);
	this.contents = contents;
    }

    /**
      * Retrieves the contents of this address. The result is a string.
      *
      * @return The possibly null address contents.
      */
    public Object getContent() {
	return contents;
    }
}
