/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 *
 * Copyright 1999, 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.sun.enterprise.resource;

import java.io.PrintWriter;
import java.io.PrintStream;

public class PoolingException extends Exception {

    private Exception ex;

    public PoolingException() {
    }

    public PoolingException(String s) {
        super(s);
    }

    public PoolingException(Exception ex) {
        super(ex.getMessage());
        this.ex = ex;
    }

    public PoolingException(String s, Exception ex) {
        super(s);
        this.ex = ex;
    }

    public Exception getNestedException() {
        return ex;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (ex != null) {
            ex.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (ex != null) {
            ex.printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (ex != null) {
            ex.printStackTrace(pw);
        }
    }

}
