/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PortabilityUtils.java
 *
 * Created on January 6, 2002, 3:42 PM
 */

package com.sun.enterprise.resource;

import java.util.Timer;
import java.lang.reflect.Method;
import java.util.logging.*;
// START OF IASRI 4691850
import java.lang.reflect.Field;
// END OF IASRI 4691850


/**
 *
 * @author  kg88722
 * @version 
 */
/**
 *This is a utility class.
 */
public class PortabilityUtils extends java.lang.Object {

    /** Creates new PortabilityUtils */
    public PortabilityUtils() {
    }

    // START OF IASRI 4691850
    // Create logger object per Java SDK 1.4 to log messages
    // introduced Santanu De, Sun Microsystems, March 2002

    /*static Logger _logger = null;
    static{
           _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
          }*/
    // END OF IASRI 4691850

    /**
     * @return Timer object.
     */
    public static Timer GetTimer() {
        try {
            //try to get the Class object, if we are running in iAS this will work
            Class cls = Class.forName("com.sun.enterprise.Switch");
            Class param[] = new Class[0];
            //get the getSwitch method
            Method meth = cls.getMethod("getSwitch",param);
            //invoke the getSwitch method will return the Switch
            Object obj = meth.invoke(cls,(java.lang.Object[])param);
            //get the Switch class object
            //cls = obj.getClass();
            //get the getTimer method
            meth = cls.getMethod("getTimer",param);
            //invoke the getTimer method
            obj = meth.invoke(obj,(java.lang.Object[])param);
            //return the Timer
            return (Timer)obj;
        } catch (ClassNotFoundException ex) {
             //if we are not running in iAS then create a new Timer
             return new Timer(true);
        } catch (Exception ex) {
            //_logger.log(Level.FINE,ex.toString());
            return new Timer(true);
        }
      }
}
