/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;

import java.util.*;
import java.util.logging.*;

import javax.transaction.Transaction;
import javax.transaction.SystemException;

import com.sun.logging.*;
import com.sun.enterprise.*;
import com.sun.enterprise.log.Log;

/**
 * SystemResourceManagerImpl manages the resource requests from system
 *
 * @author Binod PG
 */ 
public class SystemResourceManagerImpl implements ResourceManager {


    static Logger _logger = null;
    static {
        _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    }


    /**
     * Returns the transaction component is participating.
     *
     * @return Handle to the <code>Transaction</code> object.
     * @exception <code>PoolingException<code> If exception is thrown
     *         while getting the transaction.
     */
    public Transaction getTransaction() throws PoolingException{
        try {
            J2EETransactionManager tm =
                Switch.getSwitch().getTransactionManager();
            return tm.getTransaction();
        } catch (Exception ex) {
            _logger.log(Level.SEVERE,"poolmgr.unexpected_exception",ex);
            throw new PoolingException(ex.toString(), ex);
        }
    }

    /**
     * Return null for System Resource.
     */
    public Object getComponent() {        
        return null;
    }
    
    /**
     * Register the <code>ResourceHandle</code> in the transaction
     *
     * @param h	<code>ResourceHandle</code> object
     * @exception <code>PoolingException</code> If there is any error while 
     *        enlisting.
     */    
    public void enlistResource(ResourceHandle handle) throws PoolingException{
        try {
            J2EETransactionManager tm =
                Switch.getSwitch().getTransactionManager();
            Transaction tran = tm.getTransaction();
	    if (tran != null) {
                tm.enlistResource(tran, handle);
            }
	} catch (Exception ex) {
            _logger.log(Level.SEVERE,"poolmgr.unexpected_exception",ex);
            throw new PoolingException(ex.toString(), ex);
        }           
    }                

    /**
     * Dont do any thing for System Resource.
     */
    public void registerResource(ResourceHandle handle) 
         throws PoolingException {
    }
    
    public void rollBackTransaction() {
        try {
            J2EETransactionManager tm =
                Switch.getSwitch().getTransactionManager();
            Transaction tran = tm.getTransaction();
	    if ( tran != null ) {
                tran.setRollbackOnly();
	    }
        } catch (SystemException ex) {
            _logger.log(Level.WARNING,"poolmgr.system_exception",ex);
        } catch (IllegalStateException ex) {
            // ignore
        }    
    }
   
    /**
     * delist the <code>ResourceHandle</code> from the transaction
     *
     * @param h	<code>ResourceHandle</code> object
     * @param xaresFlag flag indicating transaction success. This can
     *        be XAResource.TMSUCCESS or XAResource.TMFAIL     
     * @exception <code>PoolingException</code>
     */       
    public void delistResource(ResourceHandle h, int xaresFlag) {
        try {
            J2EETransactionManager tm =
                Switch.getSwitch().getTransactionManager();
            Transaction tran = tm.getTransaction();
	    if (tran != null) {
                tm.delistResource(tran, h, xaresFlag);
            }		
        } catch (SystemException ex) {
            _logger.log(Level.WARNING,"poolmgr.system_exception",ex);
        } catch (IllegalStateException ex) {
            // ignore
        }            
    }   
    
    /**
     * Dont do any thing for System Resource.
     */
    public void unregisterResource(ResourceHandle resource,
                                   int xaresFlag) {        
    }
}
