/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;
import javax.resource.spi.*;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * This class is a ConnectionEventListener for handling the "close" of a 
 * ManagedConnection that is not acquired through the appserver's pool.
 * The ManagedConnection is simply destroyed after close is called
 * Such an "unpooled" ManagedConnection is obtained for testConnectionPool
 * and the ConnectorRuntime.getConnection() APIs
 *
 * @author Aditya Gore
 * @since SJSAS 8.1
 */
public class UnpooledConnectionEventListener implements ConnectionEventListener {
    

    static Logger _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);

    public void connectionClosed(ConnectionEvent evt) {
        ManagedConnection mc = (ManagedConnection) evt.getSource();
	try {
	    mc.destroy();
	} catch( Throwable re ) {
	     if (_logger.isLoggable(Level.FINE)) {
	         _logger.fine("error while closing testConnectionPool's mc");   
	     }
	}
	if (_logger.isLoggable(Level.FINE)) {
	    _logger.fine("UnpooledConnectionEventListener: Connection closed");
	}
    }
        
    public void connectionErrorOccurred(ConnectionEvent evt) {
        //no-op
    }

    public void localTransactionStarted(ConnectionEvent evt) {
            // no-op
    }

    public void localTransactionCommitted(ConnectionEvent evt) {
         // no-op
    }

    public void localTransactionRolledback(ConnectionEvent evt) {
        // no-op
    }

}

