/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource.monitor;
import java.util.logging.Level;

import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats;


import com.sun.enterprise.resource.MonitorableResourcePool;
/**
 * This class provides an implementation of the JDBCConnectionPoolStats
 * interface.
 * The implementations of the interface methods primarily delegate the
 * task of statistic gathering to the Pool.
 *
 * @author Aditya Gore, Sivakumar Thyagarajan
 */

public class JDBCConnectionPoolStatsImpl extends ConnectionPoolStatsImpl
                                    implements JDBCConnectionPoolStats  {
    /**
     * The constructor for the class
     *
     * @param pool - The resource pool whose stats we are storing
     */
    public JDBCConnectionPoolStatsImpl( MonitorableResourcePool pool ) {
        super();
        String statsInterface = "com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats";
        pool_ = pool;
        initializeStatistics();
        try {
            gsImpl = new GenericStatsImpl(statsInterface, this );
        } catch( ClassNotFoundException cnfe ) {
            _logger.log( Level.INFO, "poolmon.cnfe", "GenericStatsImpl" );
        }
    }
}
