/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security;

import java.security.Principal;
import javax.security.auth.Subject;

/**
 * This base class defines the methods that Security Context should exhibit.
 * There are two places where a derived class are used. They are on the 
 * appclient side and ejb side. The derived classes can use thread local
 * storage to store the security contexts.
 * 
 * @author Harpreet Singh
 */
public abstract class AbstractSecurityContext implements java.io.Serializable {
    // the principal that this security context represents.
    protected Principal initiator = null;
    protected Subject subject = null;
    
    /**
     * This method should  be implemented by the subclasses to
     * return the caller principal. This information may be redundant
     * since the same information can be inferred by inspecting the
     * Credentials of the caller. 
     * @return The caller Principal. 
     */
    abstract public Principal getCallerPrincipal();
    
    /**
     * This method should be implemented by the subclasses to return 
     * the Credentials of the caller principal.
     * @return A credentials object associated with the current client 
     * invocation.
     */
    abstract public Subject getSubject();
}







