/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * GUIErrorDialog.java
 * An error dialog box used for FailedLogin
 *
 * @author Harpreet Singh
 * @version 
 */

package com.sun.enterprise.security;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class GUIErrorDialog extends javax.swing.JDialog {
    String message;
    /** Creates new form GUIErrorDialog */
    public GUIErrorDialog (String message){
	super (new JFrame (), true);
	this.message = message;
	initComponents ();
	pack ();
    }
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {
        okButton = new javax.swing.JButton();
        errorLbl = new javax.swing.JLabel();
	okButton.setAlignmentX (CENTER_ALIGNMENT);
	errorLbl.setAlignmentX (CENTER_ALIGNMENT);
	getContentPane().setLayout (new javax.swing.BoxLayout (getContentPane (),BoxLayout.Y_AXIS));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        okButton.setLabel("OK");
        okButton.setActionCommand("okButton");
        okButton.setText("OK");
        okButton.addActionListener (new ActionListener (){
		public void actionPerformed (ActionEvent e){
		    dispose ();
		}
	    });
	super.addWindowListener (new WindowAdapter (){
		public void windowClosing (WindowEvent we){
		    dispose ();
		}
	    });
        errorLbl.setText("Error : "+message);
	getContentPane().add (errorLbl);
	getContentPane().add (okButton);
    }

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible (false);
        dispose ();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton okButton;
    private javax.swing.JLabel errorLbl;
    // End of variables declaration//GEN-END:variables

}
