/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AuditManager.java
 *
 * Created on July 27, 2003, 11:12 PM
 */

package com.sun.enterprise.security.audit;

/**
 * AuditManagerFactory is responsible for creating AuditManager. It also 
 * maintains a place holder for all the AuditModules specified in the domain.xml
 * and their respective init properties. These are given to the AuditManager to 
 * initialize the system properties.
 * @author  Harpreet Singh
 */
public final class AuditManagerFactory {
    private static AuditManager AUDIT_MANAGER = new AuditManager();
    private static AuditManagerFactory AMF = new AuditManagerFactory();
        
    /** get the AuditManagerFactory instance
     */
    public static AuditManagerFactory getInstance(){
        return AMF;
    }
    
    public static AuditManager getAuditManagerInstance(){
        return AUDIT_MANAGER;
    }
    
    /** Creates a new instance of AuditManager */
    private AuditManagerFactory() {
    }
}
