/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.auth;

/**
 * This interface stores the status of the authentication.
 * @author Harish Prabandham
 */

public interface AuthenticationStatus extends java.io.Serializable {
    public static final int AUTH_SUCCESS = 0; // Authentication Successful
    public static final int AUTH_FAILURE = 1; // Authentication Failed
    public static final int AUTH_CONTINUE = 2; // Continue the Authentication
    public static final int AUTH_EXPIRED = 3; // Credentials have expired.

    /**
     * This method returns the status of the authentication
     * @return An integer value indicating the status of the authentication
     */
    public int  getStatus();
    
    /**
     * This is the value returned by the Authenticator when the status
     * is AUTH_CONTINUE. This data should give an indication to the 
     * client on what else it should send to the server to complete the
     * authentication.
     * 
     * @return An array of bytes indicating the additional information
     * needed to complete the authentication.
     */
    public byte[] getContinuationData();
    
    /**
     * This is the value returned by the Authenticator when the status
     * is AUTH_CONTINUE. This data should give an indication to the 
     * client on specific authentication it needs to adopt to continue
     * on with the authentication.
     * 
     * @return An array of bytes indicating the authentication specific
     * information needed to complete the authentication.
     */
    public byte[] getAuthSpecificData();
}




