/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.auth.login;

import java.util.*;
import java.io.*;
import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import java.util.logging.*;
import com.sun.logging.*;


/**
 * This is the default callback handler provided by the application
 * client container. The container tries to use the application specified 
 * callback handler (if provided). If there is no callback handler or if
 * the handler cannot be instantiated then this default handler is used.
 */
public class ServerLoginCallbackHandler implements CallbackHandler 
{
    String username = null;
    String password = null; 

    public ServerLoginCallbackHandler(String username, String password) {
	this.username = username;
	this.password = password;
    }
    
    public ServerLoginCallbackHandler(){
	username = null;
	password = null;
    }
    
    public void setUsername(String user){
	username = user;
    }
    
    public void setPassword(String pass){
	password = pass;
    }

    
    /**
     * This is the callback method called when authentication data is
     * required. It either pops up a dialog box to request authentication
     * data or use text input.
     * @param the callback object instances supported by the login module.
     */
    public void handle(Callback[] callbacks) throws IOException,
					UnsupportedCallbackException
    {
	for (int i = 0; i < callbacks.length; i++) {
            if (callbacks[i] instanceof NameCallback){
		NameCallback nme = (NameCallback)callbacks[i];
		nme.setName(username);
	    } else if (callbacks[i] instanceof PasswordCallback){
		PasswordCallback pswd = (PasswordCallback)callbacks[i];
		pswd.setPassword(password.toCharArray());
	    }
	}
    }
}

