/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.auth.realm;

import java.security.Principal;
import com.sun.enterprise.security.auth.*;

/**
 * This interface is used by the Authentication Service to have the 
 * Principal authenticated by the realm. A realm provides an 
 * implementation of this interface.
 * @author Harish Prabandham
 * @author Harpreet Singh
 */
public interface AuthenticationHandler {
    /**
     * Returns the Realm that this Authentication Handler is authenticating
     * in.
     * @return The Realm object in which this handler is authenticating in.
     */
    public Realm getRealm();

    /**
     * This method authenticates the given principal using the specified 
     * authentication data and the Principal's Credentials. The result of
     * the authentication is returned back.
     * @param The principal (user) being authenticated.
     * @param The data needed for authentication.
     * @return boolean denoting true for success and false for failure
     * authentication.
     */
    public boolean doAuthentication(String principalName,
				    byte[] authData);
}
