/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.auth.realm;


/**
 * Exception thrown when a Realm is found to be corrupted for some reason.
 * This usually reflects some sort of problem with data structures such
 * as those holding information about users, groups, or ACLs.
 *
 * @author Harish Prabandham
 */
public class BadRealmException extends Exception
{
    /**
     * Constructs the exception, with descriptive information.
     *
     * @param info describes the problem with the realm
     */
    public BadRealmException (String info) { super (info); }
    
    public BadRealmException() {
        super();
    }
    
    public BadRealmException(Throwable cause) {
        super(cause);
    }
    
    public BadRealmException(String info, Throwable cause) {
        super(info, cause);
    }
}
