/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.authorize;

import javax.servlet.http.HttpServletRequest;
import javax.security.jacc.PolicyContextHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;

import com.sun.ejb.Invocation;
import com.sun.enterprise.security.PermissionCacheFactory;
import com.sun.enterprise.security.SecurityContext;

/**
 * This class implements a thread scoped data used for PolicyContext.
 * @author Harry Singh
 * @author Jyri Virkki
 * @author Shing Wai Chan
 *
 */
public class HandlerData {
    
    private HttpServletRequest httpReq = null;
    private Invocation inv = null;

    private HandlerData(){}


    public static HandlerData getInstance(){
	return new HandlerData();
    }

    public void setHttpServletRequest(HttpServletRequest httpReq) {
	this.httpReq = httpReq;
    }

    public void setInvocation(Invocation inv) {
        this.inv = inv;
    }

    public Object get(String key){
	if (PolicyContextHandlerImpl.HTTP_SERVLET_REQUEST.equalsIgnoreCase(key)){
	    return httpReq;
	} else if (PolicyContextHandlerImpl.SUBJECT.equalsIgnoreCase(key)){
	    return SecurityContext.getCurrent().getSubject();
	} else if (PolicyContextHandlerImpl.REUSE.equalsIgnoreCase(key)) {
            PermissionCacheFactory.resetCaches();
            return new Integer(0);
        }

        if (inv == null) {
            return null;
        }

	if (PolicyContextHandlerImpl.SOAP_MESSAGE.equalsIgnoreCase(key)){
	    MessageContext msgContext = inv.messageContext;
	    if(msgContext == null)
		return null;
	    if(msgContext instanceof SOAPMessageContext){
		SOAPMessageContext smc = (SOAPMessageContext) msgContext;
		return smc.getMessage();
	    }
	    return null;
	} else if (PolicyContextHandlerImpl.ENTERPRISE_BEAN.equalsIgnoreCase(key)){
	    return inv.getJaccEjb();
	} else if (PolicyContextHandlerImpl.EJB_ARGUMENTS.equalsIgnoreCase(key)){
            if (inv.isWebService) {
                return null;
            } else {
                return (inv.methodParams != null) ?
                    inv.methodParams : new Object[0];
            }
	}
	return null;
    }
}
