/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth; 

import java.util.ArrayList;

import javax.xml.soap.SOAPMessage;
import javax.xml.namespace.QName;

import javax.security.auth.callback.CallbackHandler;

import com.sun.enterprise.security.jauth.AuthConfig;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ServerAuthContext;
import com.sun.enterprise.security.jauth.AuthException;

import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;

import com.sun.xml.rpc.spi.runtime.StreamingHandler;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * This class is the client container's interface to the AuthConfig subsystem
 * to get AuthContext objects on which to invoke message layer authentication
 * providers. It is not intended to be layer or web services specific (see
 * getMechanisms method at end).
 */
public class ServerAuthConfig extends BaseAuthConfig {

    private static Logger logger = LogDomains.getLogger(LogDomains.SECURITY_LOGGER);

    private ServerAuthConfig(ServerAuthContext defaultContext) {
	super(defaultContext);
    }

    private ServerAuthConfig (ArrayList descriptors, ArrayList authContexts) {
	super(descriptors,authContexts);
    }

    public static ServerAuthConfig getConfig
	(String authLayer, MessageSecurityBindingDescriptor binding, 
	 CallbackHandler cbh) throws AuthException {
	ServerAuthConfig rvalue = null;
	String provider = null;
	ArrayList descriptors = null;
	ServerAuthContext defaultContext = null;
	if (binding != null) {
	    String layer = binding.getAttributeValue
		(MessageSecurityBindingDescriptor.AUTH_LAYER);
	    if (authLayer != null && layer.equals(authLayer)) {
		provider = binding.getAttributeValue
		    (MessageSecurityBindingDescriptor.PROVIDER_ID);
		descriptors = binding.getMessageSecurityDescriptors();
	    }
	}
	if (descriptors == null || descriptors.size() == 0) {
	    defaultContext = getAuthContext(authLayer,provider,null,null,cbh);
	    if (defaultContext != null) {
		rvalue = new ServerAuthConfig(defaultContext);
	    }
	} else {
	    boolean hasPolicy = false;
	    ArrayList authContexts = new ArrayList();
	    for (int i = 0; i < descriptors.size(); i++) {
		MessageSecurityDescriptor msd = 
		    (MessageSecurityDescriptor) descriptors.get(i);
		AuthPolicy requestPolicy = 
		    getAuthPolicy(msd.getRequestProtectionDescriptor());
		AuthPolicy responsePolicy = 
		    getAuthPolicy(msd.getResponseProtectionDescriptor());
 		if (requestPolicy.authRequired()||responsePolicy.authRequired()) {
		    authContexts.add
			(getAuthContext
			 (authLayer,provider,requestPolicy,responsePolicy,cbh));
		    hasPolicy = true;
		} else {
		    authContexts.add(null);
		}
	    }
	    if (hasPolicy) {
		rvalue = new ServerAuthConfig(descriptors,authContexts);
	    }
	}
	return rvalue;
    }

    private static ServerAuthContext getAuthContext 
	(String layer, String provider, AuthPolicy requestPolicy, 
	 AuthPolicy responsePolicy,CallbackHandler cbh) throws AuthException {
	AuthConfig authConfig = AuthConfig.getAuthConfig();
	return authConfig.getServerAuthContext
	    (layer,provider,requestPolicy,responsePolicy,cbh);
    }

    public ServerAuthContext 
	getAuthContext(StreamingHandler handler, SOAPMessage message) {
	return (ServerAuthContext) getContext(handler,message);
    }

    public ServerAuthContext getAuthContext
	(javax.xml.ws.handler.soap.SOAPMessageContext context) {
	return (ServerAuthContext) getContext(context);
    }

    public ServerAuthContext 
	getAuthContextForOpCode(StreamingHandler handler, int opcode) throws
	    ClassNotFoundException, NoSuchMethodException {
	return (ServerAuthContext) getContextForOpCode(handler,opcode);
    }

}
