/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.util;

import java.lang.*;

/**
 * General exception class for iAS security failures.
 *
 * <P>This class takes advantage of the JDK1.4 Throwable objects which
 * can carry the original cause of the exception. This prevents losing
 * the information on what caused the problem to arise.
 *
 * <P>Ideally there should be common top level iAS Exceptions to extend.
 *
 */

public class IASSecurityException extends Exception
{
  private boolean noMsg;
  
  /**
   * Constructor.
   *
   * @param msg The detail message.
   *
   */
  public IASSecurityException(String msg)
  {
    super(msg);
    noMsg=false;
  }


  /**
   * Constructor.
   *
   * @param msg The detail message.
   * @param cause The cause (which is saved for later retrieval by the
   *    getCause() method).
   *
   */
  public IASSecurityException(String msg, Throwable cause)
  {
    super(msg, cause);
    noMsg=false;
  }


  /**
   * Constructor.
   *
   * @param cause The cause (which is saved for later retrieval by the
   *    getCause() method).
   *
   */
  public IASSecurityException(Throwable cause)
  {
    super(cause);
    noMsg=true;
  }


  /**
   * Returns a description of this exception. If a root cause was included
   * during construction, its message is also included.
   *
   * @return Message containing information about the exception.
   *
   */
  public String getMessage()
  {
    StringBuffer sb=new StringBuffer();
    sb.append(super.getMessage());
    Throwable cause=getCause();

    if (!noMsg && cause!=null) {
      sb.append(" [Cause: ");
      sb.append(cause.toString());
      sb.append("] ");
    }

    return sb.toString();
  }




}
