/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server;

import com.sun.enterprise.instance.WebModulesManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;

/**
 * A dummy manager class that will be used by ApplicationLifecycle.
 * The only duty of this manager is to give out DummyWebModuleLoader.
 *
 * @author Binod PG
 */
public class DummyWebModuleManager extends AbstractManager {


    static Logger _logger=LogDomains.getLogger(LogDomains.LOADER_LOGGER);

    // This constructs makes the web modules manager available to the 
    // super class.
    DummyWebModuleManager(WebModulesManager manager, ClassLoader loader) {
        super(loader, manager);
    }

    // Return DummyWebModuleLoader.
    protected AbstractLoader getLoader(String id) {
        return new DummyWebModuleLoader(id, this.parentClassLoader, 
                   (WebModulesManager) this.configManager);
    }
}
