/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ManagerFactory.java
 *
 * Created on March 28, 2003, 2:20 PM
 */

package com.sun.enterprise.server;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.instance.InstanceFactory;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.appserv.server.util.PreprocessorUtil;

import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;



/**
 *
 * @author  Sandhya E
 */
public class ManagerFactory {
    
    /** J2EE Application Manager*/
    private static ApplicationManager applicationManager;
    /** Stand alone Connector module manager*/
    private static StandAloneConnectorModulesManager saConnectorManager;
    /** Stand alone Web module manager*/
    private static DummyWebModuleManager saWebManager;
    /** Stand alone Ejb module manager*/
    private static StandAloneEJBModulesManager saEJBManager;
    /** Stand alone Application Client module manager*/
    private static StandAloneAppClientModulesManager saACManager;
    /** Instance environment of current server context */
    private static InstanceEnvironment iEnv;
    /** shared class loader of current server context */
    private static ClassLoader sharedCL;
    
    /** logger to log core messages */
    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);
    
    /**
     * This method gets the Application Manager for this server context
     * @return ApplicationManager
     */
    public static ApplicationManager getApplicationManager() throws ConfigException{
        if(applicationManager == null) {    
            AppsManager appsManager =
            InstanceFactory.createAppsManager(getInstanceEnvironment(), false);
            try {
                if (appsManager.isByteCodePreprocessingEnabled()){
                    // Initialize the preprocessor.  If for some reason there's a
                    // problem, the preprocessor will be disabled before we attempt
                    // to use it.
                    PreprocessorUtil.init
                    (appsManager.getBytecodeProcessorClassNames());
                }
            } catch (ConfigException confEx) {
                _logger.log(Level.WARNING,
                            "bytecodepreprocessor.config_ex",
                            confEx);
                _logger.log(Level.WARNING,
                            "bytecodepreprocessor.disabled");
            }
            
            // manager for the j2ee applications
            applicationManager = new ApplicationManager(appsManager,getSharedClassLoader());
        }
        return applicationManager;    
    }
    
    /**
     * This method returns the stand alone connector module manager
     * @return StandAloneConnectorModulesManager
     */
    public static StandAloneConnectorModulesManager getSAConnectorModulesManager() throws ConfigException {
        if(saConnectorManager == null) {
            // config manager for stand alone connector modules
            ConnectorModulesManager connModuleManager =
            InstanceFactory.createConnectorModuleManager(getInstanceEnvironment(), false);
            
            // manager for stand alone connector modules
            saConnectorManager = new StandAloneConnectorModulesManager(
                                               connModuleManager, getSharedClassLoader());
        }
        return saConnectorManager;
    }
    
    /**
     * This method returns the *dummy* stand alone web modules manager. The returned manager
     * does not anything but sending an event to ondemand initialization framework.
     * @return StandAloneWebModulesManager
     **/
    public static DummyWebModuleManager getSAWebModulesManager() throws ConfigException {
        if(saWebManager == null) {
            // config manager for stand alone web modules
            WebModulesManager webModuleManager = new WebModulesManager(getInstanceEnvironment());
            saWebManager = new WebModuleDeployEventListener(webModuleManager, getSharedClassLoader());           
        }

        return saWebManager;
    }
    
    /**
     * This method returns the stand alone web modules manager
     * @return StandAloneEjbModulesManager
     */
    public static StandAloneEJBModulesManager getSAEJBModulesManager() throws ConfigException {
        if(saEJBManager == null) {
            // config manager for stand alone ejb modules
            EjbModulesManager ejbModuleManager =
            InstanceFactory.createEjbModuleManager(getInstanceEnvironment(), false);
            
            // manager for stand alone ejb modules
            saEJBManager = new StandAloneEJBModulesManager(ejbModuleManager, getSharedClassLoader());
        }
        return saEJBManager;
    }

    /**
     * This method returns the stand alone application client module manager
     * @return StandAloneAppClientModulesManager
     */
    public static StandAloneAppClientModulesManager getSAACModulesManager() 
	throws ConfigException {

        if(saACManager == null) {

            // config manager for stand alone application client modules
	    AppclientModulesManager acModuleManager =
		InstanceFactory.createAppclientModulesManager(getInstanceEnvironment());
            
            // manager for stand alone application client modules
            saACManager = new StandAloneAppClientModulesManager(
					acModuleManager, getSharedClassLoader());
        }
        return saACManager;
    }
    
    /**
     * Returns the instance environment of this server's runtime
     * @return InstanceEnvironment
     */
    private static InstanceEnvironment getInstanceEnvironment() {
        if(iEnv == null) {
            ServerContext sc = ApplicationServer.getServerContext();
            iEnv = sc.getInstanceEnvironment();
        }
        return iEnv;
    }
    
    /**
     * Returns the shared class loader
     * @return ClassLoader
     **/
    private static ClassLoader getSharedClassLoader() {
        if(sharedCL == null) {
            ServerContext sc = ApplicationServer.getServerContext();
            sharedCL = sc.getSharedClassLoader();            
        }
        return sharedCL;
    }
    
        
}
